@extends('layouts.app')

@section('title', 'تسجيل دخول - أون فاير 🔥')
@section('description', 'سجل دخولك لحساب أون فاير واستمتع بنقاط الولاء والعروض الخاصة')

@section('content')
<div class="min-h-screen bg-gradient-fire flex items-center justify-center py-12 px-4 sm:px-6 lg:px-8">
    <div class="max-w-md w-full space-y-8">
        <div class="text-center">
            <!-- الشعار -->
            <div class="flex justify-center">
                <div class="flex items-center gap-3">
                    <span class="text-5xl animate-fire">🔥</span>
                    <div class="text-white">
                        <h1 class="text-3xl font-bold">أون فاير</h1>
                        <p class="text-orange-200 text-sm">أشهى برجر في دمنهور</p>
                    </div>
                </div>
            </div>
            
            <!-- العنوان -->
            <h2 class="mt-6 text-3xl font-bold text-white">
                مرحباً بعودتك! 👋
            </h2>
            <p class="mt-2 text-lg text-orange-200">
                سجل دخولك للاستمتاع بتجربة طلب مميزة
            </p>
        </div>

        <!-- نموذج تسجيل الدخول -->
        <form method="POST" action="{{ route('auth.login.submit') }}" class="mt-8 space-y-6" x-data="loginForm()">
            @csrf
            <input type="hidden" name="redirect" value="{{ request('redirect') }}">
            
            <div class="space-y-4">
                <!-- رقم الهاتف -->
                <div>
                    <label for="phone" class="block text-sm font-medium text-white mb-2">
                        رقم الهاتف
                    </label>
                    <div class="relative">
                        <input id="phone" 
                               name="phone" 
                               type="tel" 
                               required 
                               value="{{ old('phone') }}"
                               placeholder="01xxxxxxxxx"
                               class="appearance-none relative block w-full px-4 py-3 pr-12 border border-transparent rounded-xl placeholder-gray-400 text-gray-900 bg-white/95 backdrop-blur focus:outline-none focus:ring-2 focus:ring-yellow-300 focus:border-transparent focus:z-10 text-lg">
                        <div class="absolute inset-y-0 right-0 pr-3 flex items-center">
                            <svg class="w-6 h-6 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path>
                            </svg>
                        </div>
                    </div>
                    @error('phone')
                        <p class="mt-2 text-sm text-red-200 bg-red-500/20 px-3 py-2 rounded-lg">{{ $message }}</p>
                    @enderror
                </div>

                <!-- كلمة المرور -->
                <div>
                    <label for="password" class="block text-sm font-medium text-white mb-2">
                        كلمة المرور
                    </label>
                    <div class="relative">
                        <input id="password" 
                               name="password" 
                               type="password" 
                               required 
                               placeholder="••••••••"
                               class="appearance-none relative block w-full px-4 py-3 pr-12 border border-transparent rounded-xl placeholder-gray-400 text-gray-900 bg-white/95 backdrop-blur focus:outline-none focus:ring-2 focus:ring-yellow-300 focus:border-transparent focus:z-10 text-lg">
                        <div class="absolute inset-y-0 right-0 pr-3 flex items-center">
                            <button type="button" @click="showPassword = !showPassword" class="text-gray-400 hover:text-gray-600">
                                <svg x-show="!showPassword" class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                </svg>
                                <svg x-show="showPassword" class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.878 9.878L8.464 8.464m1.414 1.414L14.82 14.82m-4.942-4.942L9.878 9.878"></path>
                                </svg>
                            </button>
                        </div>
                    </div>
                    @error('password')
                        <p class="mt-2 text-sm text-red-200 bg-red-500/20 px-3 py-2 rounded-lg">{{ $message }}</p>
                    @enderror
                </div>

                <!-- خيارات إضافية -->
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <input id="remember" 
                               name="remember" 
                               type="checkbox" 
                               class="h-4 w-4 text-fire-600 focus:ring-fire-500 border-gray-300 rounded">
                        <label for="remember" class="ml-2 block text-sm text-white">
                            تذكرني
                        </label>
                    </div>

                    <div class="text-sm">
                        <a href="{{ route('auth.forgot-password') }}" class="text-yellow-300 hover:text-yellow-200 font-medium">
                            نسيت كلمة المرور؟
                        </a>
                    </div>
                </div>
            </div>

            <!-- زر تسجيل الدخول -->
            <div>
                <button type="submit" 
                        :disabled="loading"
                        class="group relative w-full flex justify-center py-4 px-4 border border-transparent text-lg font-bold rounded-xl text-fire-600 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-yellow-300 transition-all duration-300 transform hover:scale-105 disabled:opacity-50 disabled:cursor-not-allowed">
                    <span x-show="!loading" class="flex items-center gap-2">
                        🔥 تسجيل الدخول
                    </span>
                    <span x-show="loading" class="flex items-center gap-2">
                        <div class="loading"></div>
                        جاري التحقق...
                    </span>
                </button>
            </div>

            <!-- رابط إنشاء حساب -->
            <div class="text-center">
                <p class="text-white">
                    ليس لديك حساب؟ 
                    <a href="{{ route('auth.register') }}" class="font-bold text-yellow-300 hover:text-yellow-200 transition-colors">
                        أنشئ حساب جديد
                    </a>
                </p>
            </div>
        </form>

        <!-- مميزات إنشاء الحساب -->
        <div class="mt-8 bg-white/10 backdrop-blur rounded-2xl p-6">
            <h3 class="text-lg font-bold text-white text-center mb-4">
                🎁 مميزات الحساب المجاني
            </h3>
            <div class="space-y-3">
                <div class="flex items-center gap-3 text-white">
                    <div class="w-8 h-8 bg-yellow-400 rounded-full flex items-center justify-center flex-shrink-0">
                        <svg class="w-4 h-4 text-fire-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11.049 2.927c.3-.921 1.603-.921 1.902 0l1.519 4.674a1 1 0 00.95.69h4.915c.969 0 1.371 1.24.588 1.81l-3.976 2.888a1 1 0 00-.363 1.118l1.518 4.674c.3.922-.755 1.688-1.538 1.118l-3.976-2.888a1 1 0 00-1.176 0l-3.976 2.888c-.783.57-1.838-.197-1.538-1.118l1.518-4.674a1 1 0 00-.363-1.118l-3.976-2.888c-.784-.57-.38-1.81.588-1.81h4.914a1 1 0 00.951-.69l1.519-4.674z"></path>
                        </svg>
                    </div>
                    <div>
                        <div class="font-semibold">نقاط الولاء</div>
                        <div class="text-sm text-orange-200">احصل على نقاط مع كل طلب</div>
                    </div>
                </div>
                
                <div class="flex items-center gap-3 text-white">
                    <div class="w-8 h-8 bg-green-400 rounded-full flex items-center justify-center flex-shrink-0">
                        <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                        </svg>
                    </div>
                    <div>
                        <div class="font-semibold">خصومات حصرية</div>
                        <div class="text-sm text-orange-200">عروض خاصة للأعضاء فقط</div>
                    </div>
                </div>
                
                <div class="flex items-center gap-3 text-white">
                    <div class="w-8 h-8 bg-blue-400 rounded-full flex items-center justify-center flex-shrink-0">
                        <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <div>
                        <div class="font-semibold">تتبع الطلبات</div>
                        <div class="text-sm text-orange-200">تتبع مباشر لحالة طلبك</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function loginForm() {
    return {
        showPassword: false,
        loading: false,
        
        init() {
            // تركيز على حقل الهاتف
            this.$nextTick(() => {
                this.$refs.phone?.focus();
            });
            
            // استمع لإرسال النموذج
            this.$el.addEventListener('submit', (e) => {
                this.loading = true;
            });
        }
    }
}

// تنسيق رقم الهاتف أثناء الكتابة
document.addEventListener('DOMContentLoaded', function() {
    const phoneInput = document.getElementById('phone');
    if (phoneInput) {
        phoneInput.addEventListener('input', function(e) {
            let value = e.target.value.replace(/\D/g, '');
            if (value.length > 11) {
                value = value.slice(0, 11);
            }
            e.target.value = value;
        });
    }
});
</script>
@endpush

<style>
@keyframes fire {
    0% { 
        transform: scale(1) rotate(0deg);
        filter: hue-rotate(0deg);
    }
    100% { 
        transform: scale(1.05) rotate(2deg);
        filter: hue-rotate(30deg);
    }
}

.animate-fire {
    animation: fire 2s ease-in-out infinite alternate;
}
</style>
