@extends('layouts.app')

@section('title', 'أون فاير 🔥 | أشهى برجر في دمنهور | توصيل سريع')
@section('description', 'أون فاير - أشهى برجر في دمنهور. طلب أونلاين، توصيل سريع في 30 دقيقة. كلاسيك برجر، تكساس برجر، دليمار برجر. خصومات حصرية ونظام نقاط الولاء.')

@section('content')
<!-- Hero Section -->
<section class="relative overflow-hidden bg-gradient-fire min-h-screen flex items-center">
    <!-- Background Pattern -->
    <div class="absolute inset-0 opacity-10">
        <div class="absolute inset-0" style="background-image: url('data:image/svg+xml,<svg width="60" height="60" viewBox="0 0 60 60" xmlns="http://www.w3.org/2000/svg"><g fill="none" fill-rule="evenodd"><g fill="%23ffffff" fill-opacity="0.1"><circle cx="30" cy="30" r="4"/></g></svg>'); background-size: 60px 60px;"></div>
    </div>
    
    <div class="container mx-auto px-4 relative z-10">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            
            <!-- المحتوى -->
            <div class="text-white space-y-6" x-data="hero()" x-init="init()">
                <div class="space-y-4">
                    <h1 class="text-5xl md:text-7xl font-black leading-tight">
                        <span class="block">أون</span>
                        <span class="block text-yellow-300 animate-pulse">فاير 🔥</span>
                    </h1>
                    <p class="text-2xl md:text-3xl font-light text-orange-100">
                        أشهى برجر في دمنهور
                    </p>
                </div>
                
                <div class="space-y-4">
                    <p class="text-lg md:text-xl text-orange-100 leading-relaxed">
                        استمتع بتجربة طعام لا تُنسى مع أشهى أنواع البرجر المحضر بأجود المكونات.
                        <br>
                        <span class="font-semibold text-yellow-300">توصيل مجاني للطلبات أكثر من 150 جنيه!</span>
                    </p>
                </div>

                <!-- إحصائيات سريعة -->
                <div class="grid grid-cols-3 gap-4 py-6">
                    <div class="text-center">
                        <div class="text-2xl font-bold text-yellow-300" x-text="animatedStats.customers"></div>
                        <div class="text-sm text-orange-200">عميل سعيد</div>
                    </div>
                    <div class="text-center">
                        <div class="text-2xl font-bold text-yellow-300" x-text="animatedStats.rating"></div>
                        <div class="text-sm text-orange-200">تقييم المطعم</div>
                    </div>
                    <div class="text-center">
                        <div class="text-2xl font-bold text-yellow-300" x-text="animatedStats.deliveryTime"></div>
                        <div class="text-sm text-orange-200">دقيقة توصيل</div>
                    </div>
                </div>

                <!-- أزرار العمل -->
                <div class="flex flex-col sm:flex-row gap-4 pt-4">
                    <a href="{{ route('products.index') }}" 
                       class="btn-fire text-white px-8 py-4 rounded-xl font-bold text-lg hover:transform hover:scale-105 transition-all duration-300 flex items-center justify-center gap-2">
                        🍔 اطلب الآن
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"></path>
                        </svg>
                    </a>
                    <a href="{{ route('products.offers') }}" 
                       class="bg-white/20 backdrop-blur text-white px-8 py-4 rounded-xl font-bold text-lg border-2 border-white/30 hover:bg-white hover:text-fire-600 transition-all duration-300 flex items-center justify-center gap-2">
                        🎯 العروض الخاصة
                    </a>
                </div>

                <!-- رسالة ترحيبية -->
                <div class="bg-white/10 backdrop-blur rounded-2xl p-6 border border-white/20">
                    <div class="flex items-center gap-3 mb-3">
                        <div class="w-12 h-12 bg-yellow-400 rounded-full flex items-center justify-center">
                            <span class="text-2xl">👨‍🍳</span>
                        </div>
                        <div>
                            <h3 class="font-bold text-lg">مرحباً بك في أون فاير!</h3>
                            <p class="text-orange-200 text-sm">نحن سعداء بزيارتك لنا</p>
                        </div>
                    </div>
                    <p class="text-orange-100 text-sm">
                        احصل على <span class="font-bold text-yellow-300">خصم 15%</span> على طلبك الأول 
                        + <span class="font-bold text-yellow-300">50 نقطة ولاء</span> مجاناً عند إنشاء حساب جديد!
                    </p>
                </div>
            </div>

            <!-- صور الطعام -->
            <div class="relative" x-data="heroImages()" x-init="init()">
                <!-- الصورة الرئيسية -->
                <div class="relative z-10">
                    <img :src="currentImage.src" 
                         :alt="currentImage.alt"
                         class="w-full max-w-lg mx-auto rounded-3xl shadow-2xl transform hover:scale-105 transition-all duration-500"
                         x-transition:enter="transition ease-out duration-300"
                         x-transition:enter-start="opacity-0 transform scale-90"
                         x-transition:enter-end="opacity-100 transform scale-100">
                </div>

                <!-- عناصر ديكوراتيف -->
                <div class="absolute -top-10 -right-10 w-20 h-20 bg-yellow-400 rounded-full opacity-20 animate-float"></div>
                <div class="absolute -bottom-10 -left-10 w-32 h-32 bg-orange-300 rounded-full opacity-20 animate-float" style="animation-delay: 2s;"></div>
                <div class="absolute top-1/2 -right-5 w-16 h-16 bg-red-400 rounded-full opacity-20 animate-float" style="animation-delay: 1s;"></div>

                <!-- مؤشرات الصور -->
                <div class="flex justify-center mt-6 gap-2">
                    <template x-for="(image, index) in images" :key="index">
                        <button @click="setCurrentImage(index)"
                                :class="index === currentImageIndex ? 'bg-white' : 'bg-white/30'"
                                class="w-3 h-3 rounded-full transition-colors"></button>
                    </template>
                </div>
            </div>
        </div>
    </div>

    <!-- موجة للانتقال -->
    <div class="absolute bottom-0 left-0 right-0">
        <svg viewBox="0 0 1440 120" class="w-full h-20">
            <path fill="#ffffff" d="M0,96L48,112C96,128,192,160,288,160C384,160,480,128,576,112C672,96,768,96,864,112C960,128,1056,160,1152,160C1248,160,1344,128,1392,112L1440,96L1440,320L1392,320C1344,320,1248,320,1152,320C1056,320,960,320,864,320C768,320,672,320,576,320C480,320,384,320,288,320C192,320,96,320,48,320L0,320Z"></path>
        </svg>
    </div>
</section>

<!-- الفئات الرئيسية -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-gray-900 mb-4">
                استكشف <span class="text-fire-gradient">قائمتنا</span>
            </h2>
            <p class="text-xl text-gray-600 max-w-2xl mx-auto">
                مجموعة متنوعة من أشهى الأطباق المحضرة بعناية من أجود المكونات
            </p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            @forelse($categories as $category)
                <a href="{{ route('products.category', $category) }}" 
                   class="group relative overflow-hidden rounded-3xl shadow-lg hover:shadow-2xl transition-all duration-300 transform hover:scale-105">
                    
                    <!-- صورة الفئة -->
                    <div class="aspect-w-16 aspect-h-12 bg-gray-200">
                        <img src="{{ $category->image_url }}" 
                             alt="{{ $category->name }}"
                             class="w-full h-64 object-cover group-hover:scale-110 transition-transform duration-500">
                    </div>

                    <!-- محتوى الفئة -->
                    <div class="absolute inset-0 bg-gradient-to-t from-black/70 to-transparent flex items-end">
                        <div class="p-6 text-white w-full">
                            <div class="flex items-center gap-3 mb-2">
                                @if($category->icon)
                                    <img src="{{ $category->icon_url }}" class="w-8 h-8" alt="">
                                @endif
                                <h3 class="text-2xl font-bold">{{ $category->name }}</h3>
                            </div>
                            @if($category->description)
                                <p class="text-gray-200 text-sm mb-3">{{ $category->description }}</p>
                            @endif
                            <div class="flex items-center justify-between">
                                <span class="text-yellow-300 font-semibold">{{ $category->products_count }} صنف</span>
                                <div class="bg-fire-500 p-2 rounded-full group-hover:bg-fire-600 transition-colors">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"></path>
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                </a>
            @empty
                <div class="col-span-full text-center py-12">
                    <div class="text-6xl mb-4">🍔</div>
                    <p class="text-gray-500">لا توجد فئات متاحة حالياً</p>
                </div>
            @endforelse
        </div>
    </div>
</section>

<!-- المنتجات المميزة -->
<section class="py-20 bg-gray-50">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-gray-900 mb-4">
                المنتجات <span class="text-fire-gradient">المميزة</span>
            </h2>
            <p class="text-xl text-gray-600">
                أشهى الأطباق التي يفضلها عملاؤنا
            </p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            @forelse($featuredProducts as $product)
                <div class="bg-white rounded-3xl shadow-lg hover:shadow-2xl transition-all duration-300 transform hover:scale-105 overflow-hidden">
                    
                    <!-- صورة المنتج -->
                    <div class="relative">
                        <img src="{{ $product->main_image }}" 
                             alt="{{ $product->name }}"
                             class="w-full h-64 object-cover">
                        
                        @if($product->discount_percentage > 0)
                            <div class="absolute top-4 right-4 bg-red-500 text-white px-3 py-1 rounded-full text-sm font-bold">
                                خصم {{ $product->discount_percentage }}%
                            </div>
                        @endif

                        @if($product->is_popular)
                            <div class="absolute top-4 left-4 bg-yellow-500 text-white px-3 py-1 rounded-full text-sm font-bold flex items-center gap-1">
                                <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                                </svg>
                                الأشهر
                            </div>
                        @endif
                    </div>

                    <!-- محتوى المنتج -->
                    <div class="p-6">
                        <div class="mb-3">
                            <h3 class="text-xl font-bold text-gray-900 mb-2">{{ $product->name }}</h3>
                            <p class="text-gray-600 text-sm line-clamp-2">{{ $product->description }}</p>
                        </div>

                        <!-- التقييم -->
                        @if($product->average_rating > 0)
                            <div class="flex items-center gap-2 mb-3">
                                <div class="flex text-yellow-400">
                                    @for($i = 1; $i <= 5; $i++)
                                        <svg class="w-4 h-4 {{ $i <= $product->average_rating ? 'text-yellow-400' : 'text-gray-300' }}" fill="currentColor" viewBox="0 0 20 20">
                                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                                        </svg>
                                    @endfor
                                </div>
                                <span class="text-sm text-gray-500">({{ $product->reviews_count }} تقييم)</span>
                            </div>
                        @endif

                        <!-- السعر -->
                        <div class="flex items-center justify-between mb-4">
                            <div class="flex items-center gap-2">
                                <span class="text-2xl font-bold text-fire-500">{{ number_format($product->price, 0) }} جنيه</span>
                                @if($product->original_price && $product->original_price > $product->price)
                                    <span class="text-lg text-gray-400 line-through">{{ number_format($product->original_price, 0) }} جنيه</span>
                                @endif
                            </div>
                            @if($product->preparation_time)
                                <div class="flex items-center gap-1 text-gray-500 text-sm">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                    </svg>
                                    {{ $product->preparation_time }}
                                </div>
                            @endif
                        </div>

                        <!-- أزرار العمل -->
                        <div class="flex gap-3">
                            <a href="{{ route('products.show', $product) }}" 
                               class="flex-1 bg-fire-500 hover:bg-fire-600 text-white px-4 py-3 rounded-xl font-semibold text-center transition-colors">
                                اطلب الآن
                            </a>
                            <button onclick="quickView({{ $product->id }})"
                                    class="px-4 py-3 border-2 border-fire-500 text-fire-500 hover:bg-fire-500 hover:text-white rounded-xl transition-colors">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                </svg>
                            </button>
                        </div>
                    </div>
                </div>
            @empty
                <div class="col-span-full text-center py-12">
                    <div class="text-6xl mb-4">🍽️</div>
                    <p class="text-gray-500">لا توجد منتجات مميزة حالياً</p>
                </div>
            @endforelse
        </div>

        <div class="text-center mt-12">
            <a href="{{ route('products.index') }}" 
               class="btn-fire text-white px-8 py-4 rounded-xl font-bold text-lg inline-flex items-center gap-2">
                تصفح جميع المنتجات
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"></path>
                </svg>
            </a>
        </div>
    </div>
</section>

<!-- الإحصائيات -->
<section class="py-20 bg-fire-600 text-white relative overflow-hidden">
    <!-- خلفية ديكوراتيف -->
    <div class="absolute inset-0 opacity-10">
        <div class="absolute inset-0" style="background-image: url('data:image/svg+xml,<svg width="40" height="40" viewBox="0 0 40 40" xmlns="http://www.w3.org/2000/svg"><g fill="%23ffffff" fill-opacity="0.1"><path d="M20 20c0-11.046-8.954-20-20-20v20h20z"/></g></svg>'); background-size: 40px 40px;"></div>
    </div>

    <div class="container mx-auto px-4 relative z-10">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold mb-4">
                أرقام تحكي <span class="text-yellow-300">قصة نجاحنا</span>
            </h2>
            <p class="text-xl text-fire-100">
                إنجازاتنا تتحدث عن جودة خدمتنا ورضا عملائنا
            </p>
        </div>

        <div class="grid grid-cols-2 lg:grid-cols-4 gap-8">
            <div class="text-center" x-data="counter({{ $stats['happy_customers'] ?? 1250 }})" x-intersect="startCounting">
                <div class="text-5xl md:text-6xl font-black text-yellow-300 mb-2" x-text="displayValue"></div>
                <div class="text-lg font-semibold text-fire-100">عميل سعيد</div>
                <div class="text-sm text-fire-200 mt-1">منذ بداية رحلتنا</div>
            </div>

            <div class="text-center" x-data="counter(4.8, 0.1)" x-intersect="startCounting">
                <div class="text-5xl md:text-6xl font-black text-yellow-300 mb-2" x-text="displayValue"></div>
                <div class="text-lg font-semibold text-fire-100">تقييم المطعم</div>
                <div class="text-sm text-fire-200 mt-1">من أصل 5 نجوم</div>
            </div>

            <div class="text-center" x-data="counter({{ $stats['daily_orders'] ?? 89 }})" x-intersect="startCounting">
                <div class="text-5xl md:text-6xl font-black text-yellow-300 mb-2" x-text="displayValue"></div>
                <div class="text-lg font-semibold text-fire-100">طلب يومياً</div>
                <div class="text-sm text-fire-200 mt-1">متوسط الطلبات اليومية</div>
            </div>

            <div class="text-center" x-data="counter({{ $stats['average_delivery_time'] ?? 25 }})" x-intersect="startCounting">
                <div class="text-5xl md:text-6xl font-black text-yellow-300 mb-2" x-text="displayValue"></div>
                <div class="text-lg font-semibold text-fire-100">دقيقة توصيل</div>
                <div class="text-sm text-fire-200 mt-1">متوسط وقت التوصيل</div>
            </div>
        </div>
    </div>
</section>

<!-- التقييمات -->
@if($latestReviews->count() > 0)
<section class="py-20 bg-gray-50">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-gray-900 mb-4">
                ماذا يقول <span class="text-fire-gradient">عملاؤنا</span>
            </h2>
            <p class="text-xl text-gray-600">
                آراء حقيقية من عملائنا الكرام
            </p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            @foreach($latestReviews as $review)
                <div class="bg-white rounded-2xl shadow-lg p-6 hover:shadow-xl transition-shadow">
                    <!-- التقييم -->
                    <div class="flex items-center gap-2 mb-4">
                        <div class="flex text-yellow-400">
                            @for($i = 1; $i <= 5; $i++)
                                <svg class="w-5 h-5 {{ $i <= $review->rating ? 'text-yellow-400' : 'text-gray-300' }}" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                                </svg>
                            @endfor
                        </div>
                        <span class="text-sm text-gray-500">{{ $review->created_at->diffForHumans() }}</span>
                    </div>

                    <!-- التعليق -->
                    <blockquote class="text-gray-700 mb-4 leading-relaxed">
                        "{{ $review->comment }}"
                    </blockquote>

                    <!-- معلومات العميل -->
                    <div class="flex items-center gap-3">
                        <img src="{{ $review->user->avatar_url }}" 
                             alt="{{ $review->user->name }}"
                             class="w-12 h-12 rounded-full">
                        <div>
                            <div class="font-semibold text-gray-900">{{ $review->user->name }}</div>
                            <div class="text-sm text-gray-500">{{ $review->product->name }}</div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>
@endif

<!-- دعوة للعمل -->
<section class="py-20 bg-gradient-fire text-white relative overflow-hidden">
    <div class="container mx-auto px-4 relative z-10">
        <div class="text-center max-w-4xl mx-auto">
            <div class="text-6xl mb-6 animate-bounce">🔥</div>
            <h2 class="text-4xl md:text-6xl font-bold mb-6">
                جاهز لتجربة <span class="text-yellow-300">لا تُنسى؟</span>
            </h2>
            <p class="text-xl md:text-2xl text-fire-100 mb-8 leading-relaxed">
                اطلب الآن واحصل على أشهى برجر في دمنهور مع توصيل سريع إلى باب منزلك
            </p>

            <div class="flex flex-col sm:flex-row gap-6 justify-center items-center">
                <a href="{{ route('products.index') }}" 
                   class="bg-white text-fire-600 px-12 py-4 rounded-full font-bold text-xl hover:bg-gray-100 transition-colors transform hover:scale-105 shadow-lg flex items-center gap-3">
                    🍔 اطلب الآن
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"></path>
                    </svg>
                </a>

                <div class="text-fire-100 text-center">
                    <div class="text-sm">أو اتصل بنا مباشرة</div>
                    <div class="text-2xl font-bold text-yellow-300" dir="ltr">{{ env('RESTAURANT_PHONE', '01234567890') }}</div>
                </div>
            </div>

            <!-- مميزات سريعة -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mt-16">
                <div class="flex items-center gap-3 justify-center">
                    <div class="w-12 h-12 bg-yellow-400 rounded-full flex items-center justify-center">
                        <svg class="w-6 h-6 text-fire-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <div>
                        <div class="font-bold">توصيل سريع</div>
                        <div class="text-fire-200 text-sm">خلال 30 دقيقة</div>
                    </div>
                </div>

                <div class="flex items-center gap-3 justify-center">
                    <div class="w-12 h-12 bg-yellow-400 rounded-full flex items-center justify-center">
                        <svg class="w-6 h-6 text-fire-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <div>
                        <div class="font-bold">جودة مضمونة</div>
                        <div class="text-fire-200 text-sm">مكونات طازجة</div>
                    </div>
                </div>

                <div class="flex items-center gap-3 justify-center">
                    <div class="w-12 h-12 bg-yellow-400 rounded-full flex items-center justify-center">
                        <svg class="w-6 h-6 text-fire-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"></path>
                        </svg>
                    </div>
                    <div>
                        <div class="font-bold">دفع آمن</div>
                        <div class="text-fire-200 text-sm">طرق متعددة</div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- خلفية ديكوراتيف -->
    <div class="absolute top-10 right-10 w-32 h-32 bg-yellow-400 rounded-full opacity-10 animate-float"></div>
    <div class="absolute bottom-10 left-10 w-24 h-24 bg-orange-300 rounded-full opacity-10 animate-float" style="animation-delay: 2s;"></div>
</section>
@endsection

@push('scripts')
<script>
// Hero animations
function hero() {
    return {
        animatedStats: {
            customers: 0,
            rating: 0,
            deliveryTime: 0
        },
        
        init() {
            this.animateStats();
        },
        
        animateStats() {
            const targets = {
                customers: {{ $stats['happy_customers'] ?? 1250 }},
                rating: 4.8,
                deliveryTime: {{ $stats['average_delivery_time'] ?? 25 }}
            };
            
            Object.keys(targets).forEach(key => {
                this.animateValue(key, 0, targets[key], 2000);
            });
        },
        
        animateValue(key, start, end, duration) {
            const increment = (end - start) / (duration / 16);
            let current = start;
            
            const timer = setInterval(() => {
                current += increment;
                if (current >= end) {
                    current = end;
                    clearInterval(timer);
                }
                
                if (key === 'rating') {
                    this.animatedStats[key] = current.toFixed(1);
                } else {
                    this.animatedStats[key] = Math.floor(current).toLocaleString();
                }
            }, 16);
        }
    }
}

// Hero images carousel
function heroImages() {
    return {
        currentImageIndex: 0,
        images: [
            { src: '/images/hero-burger-1.jpg', alt: 'كلاسيك برجر أون فاير' },
            { src: '/images/hero-burger-2.jpg', alt: 'تكساس برجر الشهي' },
            { src: '/images/hero-burger-3.jpg', alt: 'دليمار برجر المميز' }
        ],
        
        init() {
            this.autoSlide();
        },
        
        get currentImage() {
            return this.images[this.currentImageIndex];
        },
        
        setCurrentImage(index) {
            this.currentImageIndex = index;
        },
        
        autoSlide() {
            setInterval(() => {
                this.currentImageIndex = (this.currentImageIndex + 1) % this.images.length;
            }, 4000);
        }
    }
}

// Counter animation
function counter(target, step = 1) {
    return {
        current: 0,
        target: target,
        step: step,
        displayValue: 0,
        counting: false,
        
        startCounting() {
            if (this.counting) return;
            this.counting = true;
            
            const increment = this.target / 100;
            const timer = setInterval(() => {
                this.current += increment;
                if (this.current >= this.target) {
                    this.current = this.target;
                    clearInterval(timer);
                }
                
                if (this.step < 1) {
                    this.displayValue = this.current.toFixed(1);
                } else {
                    this.displayValue = Math.floor(this.current).toLocaleString();
                }
            }, 20);
        }
    }
}

// Quick view function
function quickView(productId) {
    // هنا يمكن إضافة منطق العرض السريع للمنتج
    showToast('ميزة العرض السريع قريباً!', 'info');
}

// Add some CSS animations
const style = document.createElement('style');
style.textContent = `
    @keyframes float {
        0%, 100% { transform: translateY(0px); }
        50% { transform: translateY(-20px); }
    }
    .animate-float {
        animation: float 6s ease-in-out infinite;
    }
    .line-clamp-2 {
        display: -webkit-box;
        -webkit-line-clamp: 2;
        -webkit-box-orient: vertical;
        overflow: hidden;
    }
`;
document.head.appendChild(style);
</script>
@endpush
