@extends('layouts.app')

@section('title', 'القائمة - أون فاير 🔥')
@section('description', 'اكتشف قائمة أون فاير الشاملة - أشهى أنواع البرجر والوجبات في دمنهور')

@section('content')
<div class="min-h-screen bg-gray-50 py-8">
    <div class="container mx-auto px-4">
        
        <!-- Header -->
        <div class="text-center mb-12">
            <h1 class="text-4xl md:text-6xl font-bold text-gray-900 mb-4">
                🍔 قائمة <span class="text-fire-gradient">أون فاير</span>
            </h1>
            <p class="text-xl text-gray-600 max-w-2xl mx-auto">
                اختر من بين أشهى الأطباق المحضرة بحب وعناية من أجود المكونات
            </p>
        </div>

        <!-- Products Grid -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            @forelse($products as $product)
                <div class="bg-white rounded-2xl shadow-lg hover:shadow-2xl transition-all duration-300 transform hover:scale-105 overflow-hidden">
                    
                    <!-- Product Image -->
                    <div class="relative">
                        <img src="{{ $product->main_image }}" 
                             alt="{{ $product->name }}"
                             class="w-full h-64 object-cover">
                        
                        @if($product->discount_percentage > 0)
                            <div class="absolute top-4 right-4 bg-red-500 text-white px-3 py-1 rounded-full text-sm font-bold">
                                خصم {{ $product->discount_percentage }}%
                            </div>
                        @endif

                        @if($product->is_popular)
                            <div class="absolute top-4 left-4 bg-yellow-500 text-white px-3 py-1 rounded-full text-sm font-bold">
                                الأشهر ⭐
                            </div>
                        @endif
                    </div>

                    <!-- Product Details -->
                    <div class="p-6">
                        <h3 class="text-xl font-bold text-gray-900 mb-2">{{ $product->name }}</h3>
                        <p class="text-gray-600 text-sm mb-4">{{ $product->description }}</p>

                        <!-- Price -->
                        <div class="flex items-center gap-2 mb-4">
                            <span class="text-2xl font-bold text-fire-500">{{ number_format($product->price, 0) }} جنيه</span>
                            @if($product->original_price && $product->original_price > $product->price)
                                <span class="text-lg text-gray-400 line-through">{{ number_format($product->original_price, 0) }} جنيه</span>
                            @endif
                        </div>

                        <!-- Add to Cart Button -->
                        <button onclick="addToCart({{ $product->id }})"
                                class="w-full bg-fire-500 hover:bg-fire-600 text-white py-3 rounded-xl font-semibold transition-colors">
                            🛒 إضافة للسلة
                        </button>
                    </div>
                </div>
            @empty
                <div class="col-span-full text-center py-16">
                    <div class="text-6xl mb-4">🍔</div>
                    <h3 class="text-2xl font-bold text-gray-900 mb-2">لا توجد منتجات</h3>
                    <p class="text-gray-600">لم نعثر على منتجات متاحة حالياً</p>
                </div>
            @endforelse
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
async function addToCart(productId) {
    try {
        const response = await fetch('{{ route("cart.add") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
            },
            body: JSON.stringify({
                product_id: productId,
                quantity: 1
            })
        });
        
        const data = await response.json();
        
        if (data.success) {
            showToast('تم إضافة المنتج للسلة بنجاح! 🛒', 'success');
        } else {
            showToast(data.message, 'error');
        }
    } catch (error) {
        console.error('Error:', error);
        showToast('حدث خطأ أثناء إضافة المنتج للسلة', 'error');
    }
}
</script>
@endpush
